﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;

namespace IndianHealthService.BMXNet
{
    /// <summary>
    /// The event args used by the RemoteEventService
    /// </summary>
    public class RemoteEventArgs : EventArgs
    {
        private String _eventType = null;

        /// <summary>
        /// This string corresponds to well-known/shared EventTypes used to identify 
        /// different events published and subscribed between BMX implementations using RemoteSessions.
        /// </summary>
        public String EventType
        {
            get { return _eventType; }
            set { _eventType = value; }
        }
        private String _details = null;

        /// <summary>
        /// This is an optional peice of data with some event-specific details.
        /// </summary>
        public String Details
        {
            get { return _details; }
            set { _details = value; }
        }
    }
}
